# Plugin WordPress - CryptNote Secure Links

Plugin para integrar o WordPress ao **CryptNote.pro**, permitindo gerar links criptografados direto do painel e substituir o corpo dos e-mails enviados pelo site por um link seguro que precisa ser aberto para exibir o conteúdo.

## Instalação
- Copie a pasta `plugin-wordpress` para `wp-content/plugins/` do seu WordPress (ou compacte em `.zip` e envie pela tela de plugins).
- No painel de plugins, ative **CryptNote Secure Links**.

## Configuração
Abra *CryptNote* no menu lateral do admin e ajuste:
- **Endpoint base da API**: por padrão `https://cryptnote.pro/api/v1`. Se estiver usando outro domínio/instância, troque aqui (o plugin chama `POST {api_base}/create.php`).
- **API Key**: se a sua API exigir chave, ela será enviada no cabeçalho `X-API-Key`.
- **Visualizações padrão**: limite de acessos do link (1–20) e expiração padrão em minutos (em branco para sem expiração por tempo).
- **Markdown**: marca mensagens automáticas como Markdown (`is_markdown=true`).
- **E-mails seguros**: ao marcar, todo `wp_mail()` terá o corpo substituído por um link CryptNote. Anexos são removidos para evitar vazamento de dados.
- **Template do e-mail**: corpo enviado quando os e-mails são protegidos. Placeholders disponíveis: `{share_url}`, `{token}`, `{max_views}`, `{expire_minutes}`.

## Gerar links pelo painel
Na mesma tela existe um formulário **Gerar link criptografado agora**:
- Informe o conteúdo, senha opcional, limite de visualizações, expiração e se deve ser Markdown.
- O plugin chama a API de criação e exibe o `share_url` e o `token` gerados.

## Como funciona a proteção de e-mails
- Quando a opção “Habilitar links seguros para todos os e-mails” está ativa, o filtro `wp_mail` cria um link no CryptNote com o corpo original do e-mail e substitui a mensagem por um texto contendo apenas o link.
- Em caso de falha na API, o e-mail é enviado com um aviso de erro e **não** inclui o conteúdo original.
- Anexos são descartados para garantir que nada sensível seja enviado fora do link.

## Payload usado na API
`POST {api_base}/create.php` com JSON:
```json
{
  "content": "mensagem",
  "is_markdown": false,
  "max_views": 1,
  "password": "opcional",
  "expire_minutes": 60
}
```
Resposta esperada: `{"success":true,"share_url":"...","token":"..."}`.
