# CryptNote Translations

This folder contains translation files for the CryptNote Secure Links plugin.

## Files

- `cryptnote.pot` - Translation template (source strings in English)
- `cryptnote-pt_BR.po` - Portuguese (Brazil) translation source
- `cryptnote-pt_BR.mo` - Portuguese (Brazil) compiled translation (binary)

## How to Generate .mo Files

The `.mo` file is the compiled binary that WordPress uses. To generate it:

### Option 1: Using WP-CLI
```bash
wp i18n make-mo languages/cryptnote-pt_BR.po languages/cryptnote-pt_BR.mo
```

### Option 2: Using Poedit
1. Open the `.po` file in [Poedit](https://poedit.net/)
2. Save the file - Poedit automatically generates the `.mo` file

### Option 3: Using msgfmt (gettext)
```bash
msgfmt -o cryptnote-pt_BR.mo cryptnote-pt_BR.po
```

## Adding New Translations

1. Copy `cryptnote.pot` to `cryptnote-{locale}.po` (e.g., `cryptnote-es_ES.po` for Spanish)
2. Translate all strings in the new `.po` file
3. Generate the `.mo` file using one of the methods above

## Supported Locales

- `en_US` - English (default, no translation file needed)
- `pt_BR` - Portuguese (Brazil)
